﻿using System.Collections.Generic;
using System.Reflection;

namespace BCS.Northwind
{
	internal static class Extensions
	{
		/// <summary>
		/// copy values for each propery from other to current
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="current"></param>
		/// <param name="other"></param>
      internal static void UpdateWith<T>(this T current, T other)
		{
		   foreach (PropertyInfo property in current.GetType().GetProperties())
		   {
		      object oldValue = property.GetValue(current, null);
		      object newValue = property.GetValue(other, null);
            if ((oldValue == null && newValue == null) || (oldValue != null && oldValue.Equals(newValue)))
		      {
		         // don't update if the value is the same
		         continue;
		      }

		      property.SetValue(current, newValue, null);
		   }
		}

      internal static IEnumerable<T> AsEnumerable<T>(this T current) where T : class
      {
         if (current == null) yield break;
         yield return current;
      }

	}
}
